/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#include "threestatebutton.h"

ThreeStateButton::ThreeStateButton(QWidget *parent) :
    QPushButton(parent)
{
    m_nState = 0;
    connect(this,SIGNAL(released()),this,SLOT(released()));
}

void ThreeStateButton::released()
{
    if(getState() == noCheck)
        setState(singleCheck);
    else if(getState() == singleCheck)
        setState(doubleCheck);
    else if(getState() == doubleCheck)
        setState(noCheck);
}

int ThreeStateButton::getState()
{
    return m_nState;
}

void ThreeStateButton::setState(int nState)
{
    m_nState = nState;

    if(getState() == noCheck)
    {
        setIcon(m_icoNoCheck);
        setText(m_sNoCheckLabel);
        setChecked(false);
    }
    else if(getState() == singleCheck)
    {
        setIcon(m_icoSingleCheck);
        setText(m_sSingleCheckLabel);
        setChecked(true);
    }
    else if(getState() == doubleCheck)
    {
        setIcon(m_icoDoubleCheck);
        setText(m_sDoubleCheckLabel);
        setChecked(true);
    }
}

void ThreeStateButton::setGraphicNoCheck(QString sFileName,QString sLabel)
{
    m_icoNoCheck = QIcon(sFileName);
    m_sNoCheckLabel = sLabel;
}

void ThreeStateButton::setGraphicSingleCheck(QString sFileName,QString sLabel)
{
    m_icoSingleCheck = QIcon(sFileName);
    m_sSingleCheckLabel = sLabel;

}

void ThreeStateButton::setGraphicDoubleCheck(QString sFileName,QString sLabel)
{
    m_icoDoubleCheck = QIcon(sFileName);
    m_sDoubleCheckLabel = sLabel;
}

